/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.saverest.cloning;

import com.ibm.hwmca.base.saverest.SaveRestoreDataObject;
import com.ibm.hwmca.base.saverest.cloning.CloningConstants;
import com.ibm.hwmca.base.saverest.cloning.CloningErrorIds;
import com.ibm.hwmca.base.saverest.cloning.CloningSettingsBean;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.FcsServiceId;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.MicrocodeLogAttributes;
import com.ibm.hwmca.fw.persist.PersistenceClassNotFoundException;
import com.ibm.hwmca.fw.persist.PersistenceInvalidNameException;
import com.ibm.hwmca.fw.persist.PersistenceIsParentException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.persist.PersistencePersistentDataConstructorNotFoundException;
import com.ibm.hwmca.fw.persist.PersistenceReadException;
import com.ibm.hwmca.fw.persist.PersistenceUnsupportedVersionException;
import com.ibm.hwmca.fw.persist.PersistenceWriteException;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;
import java.util.HashMap;

public class CloningSettingsTasklet
extends PanelTasklet
implements CloningConstants,
CloningErrorIds {
    private static final String TRACE_MASKT = "XSRDCSTT";
    private static final String TRACE_MASKF = "XSRDCSTF";
    private static final String TRACE_MASKD = "XSRDCSTD";

    public void logException(Throwable throwable) {
        new FrameworkLog(CloningErrorIds._logInfo, 257, throwable).log();
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> CloningTasklet.service()");
        String command = (String)request.getData("event");
        if (command == null) {
            command = "";
        }
        if (request.isInitialRequest()) {
            this.handleInitial(request, response);
        } else if (request.isDisposed() || request.isCanceled()) {
            Trace.trace(TRACE_MASKT, "Terminating the tasklet");
            response.terminate();
        } else if (command.equals("DataMapAllowLocalCloning")) {
            this.handleLocalCloningSelection(request, response);
        } else {
            throw new TaskletException("Unknown state!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleInitial(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        block23: {
            Trace.trace(TRACE_MASKT, "-> CloningSettingsTasklet.handleInitial()");
            try {
                CloningSettingsBean cloningSettingsBean = new CloningSettingsBean();
                cloningSettingsBean.setBeanName("CloningSettingsBean");
                HashMap<String, Boolean> data = new HashMap<String, Boolean>();
                PersistenceManager pMgr = PersistenceManager.getPersistenceManager();
                SaveRestoreDataObject srdo = null;
                if (pMgr.contains("com.ibm.hwmca.base.saverest.SaveRestoreKey")) {
                    Trace.trace(TRACE_MASKF, "Have persistent data, reading it in");
                    try {
                        srdo = (SaveRestoreDataObject)pMgr.read("com.ibm.hwmca.base.saverest.SaveRestoreKey");
                    }
                    catch (PersistenceIsParentException pipe) {
                        Trace.trace(TRACE_MASKF, pipe);
                    }
                    catch (PersistenceReadException pre) {
                        Trace.trace(TRACE_MASKF, pre);
                    }
                    catch (PersistenceClassNotFoundException pcnfe) {
                        Trace.trace(TRACE_MASKF, pcnfe);
                    }
                    catch (PersistencePersistentDataConstructorNotFoundException ppdcnfe) {
                        Trace.trace(TRACE_MASKF, ppdcnfe);
                    }
                    catch (PersistenceUnsupportedVersionException puve) {
                        Trace.trace(TRACE_MASKF, puve);
                    }
                    finally {
                        if (srdo == null) {
                            srdo = new SaveRestoreDataObject();
                        }
                    }
                } else {
                    Trace.trace(TRACE_MASKF, "no persistent data?  Perhaps we were removed from the startup?");
                    srdo = new SaveRestoreDataObject();
                    try {
                        pMgr.write("com.ibm.hwmca.base.saverest.SaveRestoreKey", srdo);
                    }
                    catch (PersistenceIsParentException pipe) {
                        Trace.trace(TRACE_MASKF, pipe);
                    }
                    catch (PersistenceInvalidNameException pine) {
                        Trace.trace(TRACE_MASKF, pine);
                    }
                    catch (PersistenceWriteException pwe) {
                        Trace.trace(TRACE_MASKF, pwe);
                    }
                }
                data.put("DataMapAllowLocalCloning", srdo.isEnableHmcCloning() ? Boolean.TRUE : Boolean.FALSE);
                cloningSettingsBean.setData(data);
                response.replace("com.ibm.hwmca.base.saverest.cloning.res.CloningRes", "CloningSettings", cloningSettingsBean);
            }
            catch (Exception e) {
                new FrameworkLog(CloningErrorIds._logInfo, 258, e).log(MicrocodeLogAttributes.INFO_LOG);
                if (response.isResponseSet()) break block23;
                response.terminate();
            }
        }
        Trace.trace(TRACE_MASKT, "<- CloningTasklet.handleInitial()");
    }

    private void handleLocalCloningSelection(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Object o;
        Trace.trace(TRACE_MASKT, "-> handleLocalCloningSelection()");
        Boolean b = (Boolean)request.getData("DataMapAllowLocalCloning");
        if (b == null) {
            b = Boolean.FALSE;
        }
        PersistenceManager pMgr = PersistenceManager.getPersistenceManager();
        SaveRestoreDataObject srdo = null;
        if (pMgr.contains("com.ibm.hwmca.base.saverest.SaveRestoreKey")) {
            Trace.trace(TRACE_MASKF, "Have persistent data, reading it in");
            try {
                srdo = (SaveRestoreDataObject)pMgr.read("com.ibm.hwmca.base.saverest.SaveRestoreKey");
            }
            catch (PersistenceIsParentException pipe) {
                Trace.trace(TRACE_MASKF, pipe);
            }
            catch (PersistenceReadException pre) {
                Trace.trace(TRACE_MASKF, pre);
            }
            catch (PersistenceClassNotFoundException pcnfe) {
                Trace.trace(TRACE_MASKF, pcnfe);
            }
            catch (PersistencePersistentDataConstructorNotFoundException ppdcnfe) {
                Trace.trace(TRACE_MASKF, ppdcnfe);
            }
            catch (PersistenceUnsupportedVersionException puve) {
                Trace.trace(TRACE_MASKF, puve);
            }
        }
        if (srdo == null) {
            srdo = new SaveRestoreDataObject();
        }
        if (b.booleanValue() != srdo.isEnableHmcCloning()) {
            srdo.setEnableHmcCloning(b);
            FcsServiceId serviceId = new FcsServiceId("com.ibm.hwmca.base.saverest.cloning.CloningToken", 1.0);
            if (b.booleanValue()) {
                Trace.trace(TRACE_MASKF, "adding local service");
                FcsServer.getFcsServer().addLocalService(serviceId, "com.ibm.hwmca.base.saverest.cloning.CloningService");
            } else {
                Trace.trace(TRACE_MASKF, "removing local service");
                FcsServer.getFcsServer().removeLocalService(serviceId);
            }
            try {
                Trace.trace(TRACE_MASKF, "writing out the new value for the data store");
                pMgr.write("com.ibm.hwmca.base.saverest.SaveRestoreKey", srdo);
            }
            catch (PersistenceIsParentException pipe) {
                Trace.trace(TRACE_MASKF, pipe);
            }
            catch (PersistenceInvalidNameException pine) {
                Trace.trace(TRACE_MASKF, pine);
            }
            catch (PersistenceWriteException pwe) {
                Trace.trace(TRACE_MASKF, pwe);
            }
        }
        if ((o = request.getData("ButtonName")) != null && o instanceof String) {
            if (((String)o).equals("ApplyButton")) {
                response.noAction();
            } else {
                response.terminate();
            }
        } else {
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<- handleLocalCloningSelection()");
    }
}

